/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCAxis;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLineStyle;
import jclass.chart.JCSymbolStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class PlotChartDraw
extends ChartDraw {
    Vector[] pts;
    int[][] ptsIndex;
    boolean inStartEdit = false;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point prev;
    Point next;
    Point last;
    Rectangle r;
    public static final int TOP_EDGE = 8;
    public static final int BOTTOM_EDGE = 4;
    public static final int RIGHT_EDGE = 2;
    public static final int LEFT_EDGE = 1;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n, int n2) {
        this.recalc(n, n2, -1);
    }

    public void recalc(int n, int n2, int n3) {
        boolean bl;
        super.recalc();
        this.fastUpdate = this.dataObject.getFastUpdate();
        if (this.fastUpdate) {
            bl = true;
            this.cachePlotData = true;
        } else {
            bl = this.inStartEdit;
            this.cachePlotData = this.dataObject.getBufferPlotData();
        }
        boolean bl2 = false;
        if (n >= 0 && n2 >= 0 && n2 >= n && this.pts != null) {
            bl2 = true;
        }
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.inverted = this.xaxis.isVertical;
        if (!bl && !this.cachePlotData && n3 == -1) {
            if (this.pts == null) {
                this.pts = new Vector[this.seriesList.length];
            }
            return;
        }
        if (n3 == -1 || n3 == 0) {
            this.xlim = new MinMax();
            this.ylim = new MinMax();
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
        if (!bl2) {
            this.pts = new Vector[this.seriesList.length];
            this.ptsIndex = bl ? new int[this.seriesList.length][] : null;
        }
        int n4 = n3 == -1 ? 0 : n3;
        int n5 = n3 == -1 ? this.seriesList.length : n3 + 1;
        int n6 = n4;
        while (n6 < n5) {
            ChartDataViewSeries chartDataViewSeries = this.seriesList[n6];
            if (!bl2) {
                this.pts[n6] = null;
                if (bl) {
                    this.ptsIndex[n6] = null;
                }
            }
            if (chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                int n7;
                int n8;
                if (!bl2) {
                    n = chartDataViewSeries.getFirstPoint();
                    n2 = chartDataViewSeries.getLastPoint();
                    n8 = Math.min(chartDataViewSeries.maxXIndex(), chartDataViewSeries.maxYIndex());
                    this.pts[n6] = new Vector(n8);
                    if (bl) {
                        this.ptsIndex[n6] = new int[n8];
                        int n9 = 0;
                        while (n9 < n8) {
                            this.ptsIndex[n6][n9] = -1;
                            ++n9;
                        }
                    }
                } else {
                    n8 = n2 + 1;
                    int[] nArray = this.ptsIndex[n6];
                    int n10 = nArray == null ? 0 : nArray.length;
                    this.ptsIndex[n6] = new int[n8];
                    if (nArray != null) {
                        System.arraycopy(nArray, 0, this.ptsIndex[n6], 0, nArray.length);
                    }
                    int n11 = n10;
                    while (n11 < n8) {
                        this.ptsIndex[n6][n11] = -1;
                        ++n11;
                    }
                    if (n < n10) {
                        n = n10;
                    }
                }
                this.holeValue = this.dataObject.holeValue;
                double d = 0.0;
                double d2 = this.holeValue;
                boolean bl3 = false;
                int n12 = 0;
                if (bl2 && n > 0) {
                    n7 = this.ptsIndex[n6][n - 1];
                    if (n7 == -1) {
                        int n13 = n - 2;
                        while (n7 == -1 && n13 >= 0) {
                            n7 = this.ptsIndex[n6][n13];
                            --n13;
                        }
                        if (n7 != -1) {
                            n12 = n7 + 1;
                        }
                    } else {
                        n12 = n7;
                        PlotPoint plotPoint = (PlotPoint)this.pts[n6].elementAt(n12);
                        d = chartDataViewSeries.getX(plotPoint.point);
                        d2 = chartDataViewSeries.getY(plotPoint.point);
                        ++n12;
                        bl3 = true;
                    }
                }
                n7 = n;
                while (n7 <= n2) {
                    double d3 = chartDataViewSeries.getX(n7);
                    double d4 = chartDataViewSeries.getY(n7);
                    bl3 = this.plotClip(d, d2, d3, d4, this.xlim, this.ylim, this.pts[n6], n7, n12, 0, bl3, this.inverted);
                    while (n12 < this.pts[n6].size()) {
                        PlotPoint plotPoint = (PlotPoint)this.pts[n6].elementAt(n12);
                        if (plotPoint != null && bl) {
                            this.ptsIndex[n6][plotPoint.point] = n12;
                        }
                        ++n12;
                    }
                    if (!bl3 && n12 > 0 && this.pts[n6].elementAt(n12 - 1) != null) {
                        this.pts[n6].addElement(null);
                        ++n12;
                    }
                    d = d3;
                    d2 = d4;
                    ++n7;
                }
            }
            ++n6;
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n, int n2) {
        try {
            if (this.seriesList == null) {
                return;
            }
            if (this.fastUpdate) {
                this.cachePlotData = true;
                if (this.ptsIndex == null) {
                    this.recalc(-1, -1, -1);
                }
            }
            boolean bl = false;
            if (n >= 0 && n2 >= 0 && n2 >= n) {
                bl = true;
            }
            if (this.pts == null) {
                return;
            }
            if (this.chartType == 0) {
                this.drawLinesOrPoints(graphics, true, bl, n, n2);
            }
            this.drawLinesOrPoints(graphics, false, bl, n, n2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    private void drawLinesOrPoints(Graphics graphics, boolean bl, boolean bl2, int n, int n2) {
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        boolean bl3 = false;
        PlotPoint plotPoint = null;
        int n3 = 0;
        while (n3 < this.pts.length) {
            block14: {
                int n4;
                int n5;
                int n6;
                JCSymbolStyle jCSymbolStyle;
                JCLineStyle jCLineStyle;
                block15: {
                    JCChartStyle jCChartStyle;
                    if (!this.cachePlotData) {
                        this.recalc(-1, -1, n3);
                    }
                    if (this.pts[n3] == null) break block14;
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n3];
                    if (!chartDataViewSeries.isShowing || (jCChartStyle = chartDataViewSeries.getStyle()) == null) break block14;
                    jCLineStyle = jCChartStyle.getLineStyle();
                    jCSymbolStyle = jCChartStyle.getSymbolStyle();
                    if (!bl && jCSymbolStyle.getShape() == 0) break block14;
                    n6 = 0;
                    n5 = this.pts[n3].size();
                    int n7 = -1;
                    int n8 = -1;
                    if (!bl2) break block15;
                    if (this.chartType == 0 && n > 0) {
                        n7 = this.ptsIndex[n3][n - 1];
                    }
                    n4 = n;
                    while (n7 == -1 && n4 <= n2) {
                        n7 = this.ptsIndex[n3][n4];
                        ++n4;
                    }
                    int n9 = n2;
                    while (n8 == -1 && n9 >= n) {
                        n8 = this.ptsIndex[n3][n9];
                        --n9;
                    }
                    if (n7 == -1 || n8 == -1) break block14;
                    n6 = n7;
                    n5 = n8 + 1;
                }
                bl3 = false;
                n4 = n6;
                while (n4 < n5) {
                    plotPoint = (PlotPoint)this.pts[n3].elementAt(n4);
                    if (plotPoint == null || plotPoint.px == Integer.MAX_VALUE || plotPoint.py == Integer.MAX_VALUE) {
                        bl3 = false;
                    } else {
                        point.x = plotPoint.px;
                        point.y = plotPoint.py;
                        if (bl && bl3 && this.chartType == 0) {
                            jCLineStyle.draw(graphics, point2.x, point2.y, point.x, point.y);
                        }
                        if (!bl && plotPoint.drawPoint) {
                            jCSymbolStyle.draw(graphics, point.x, point.y);
                        }
                        point2.x = point.x;
                        point2.y = point.y;
                        bl3 = true;
                    }
                    ++n4;
                }
                if (!this.cachePlotData) {
                    this.pts[n3] = null;
                }
            }
            ++n3;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = Integer.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        if (this.fastUpdate) {
            this.cachePlotData = true;
        }
        int n5 = 0;
        while (n5 < this.pts.length) {
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n5);
            }
            if (this.pts[n5] != null && this.seriesList[n5].isShowing) {
                int n6 = 0;
                while (n6 < this.pts[n5].size()) {
                    PlotPoint plotPoint = (PlotPoint)this.pts[n5].elementAt(n6);
                    if (plotPoint != null && plotPoint.px != Integer.MAX_VALUE && plotPoint.py != Integer.MAX_VALUE && plotPoint.drawPoint) {
                        int n7 = Integer.MAX_VALUE;
                        switch (n) {
                            case 1: {
                                n7 = Math.abs(plotPoint.px - point2.x);
                                break;
                            }
                            case 2: {
                                n7 = Math.abs(plotPoint.py - point2.y);
                                break;
                            }
                            default: {
                                n7 = JCChartUtil.distance(point2.x, point2.y, plotPoint.px, plotPoint.py);
                            }
                        }
                        if (n7 < n4) {
                            n2 = n5;
                            n3 = plotPoint.point;
                            n4 = n7;
                        }
                    }
                    ++n6;
                }
                if (!this.cachePlotData) {
                    this.pts[n5] = null;
                }
            }
            ++n5;
        }
        if (n2 >= 0 && n3 >= 0) {
            jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        boolean bl;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.drawingOrder;
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        boolean bl2 = bl = this.ptsIndex == null;
        if (bl) {
            this.inStartEdit = true;
            this.recalc(-1, -1, n);
        }
        int n2 = this.ptsIndex[n][jCDataIndex.point];
        Vector vector = this.pts[n];
        PlotPoint plotPoint = null;
        if (n2 - 1 >= 0 && (plotPoint = (PlotPoint)vector.elementAt(n2 - 1)) != null && plotPoint.px != Integer.MAX_VALUE && plotPoint.py != Integer.MAX_VALUE) {
            this.prev = new Point(plotPoint.px + this.r.x, plotPoint.py + this.r.y);
        }
        if (n2 + 1 < vector.size() && (plotPoint = (PlotPoint)vector.elementAt(n2 + 1)) != null && plotPoint.px != Integer.MAX_VALUE && plotPoint.py != Integer.MAX_VALUE) {
            this.next = new Point(plotPoint.px + this.r.x, plotPoint.py + this.r.y);
        }
        this.inStartEdit = false;
        if (bl) {
            this.ptsIndex = null;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.last.x = n;
        } else {
            this.last.y = n2;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    boolean plotClip(double d, double d2, double d3, double d4, MinMax minMax, MinMax minMax2, Vector vector, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        double d5 = minMax.min;
        double d6 = minMax.max;
        double d7 = minMax2.min;
        double d8 = minMax2.max;
        JCAxis jCAxis = this.dataObject.getXAxis();
        JCAxis jCAxis2 = this.dataObject.getYAxis();
        boolean bl3 = true;
        boolean bl4 = true;
        int n5 = n - 1;
        int n6 = n;
        int n7 = 0;
        int n8 = 0;
        boolean bl5 = false;
        boolean bl6 = true;
        if (!bl) {
            if (d2 == this.dataObject.holeValue || d == this.dataObject.holeValue) {
                n7 = 1;
                bl6 = false;
                bl5 = true;
            } else {
                n7 = JCChartUtil.locateXY(d, d2, d5, d6, d7, d8);
            }
        } else {
            n7 = JCChartUtil.locateXY(d, d2, d5, d6, d7, d8);
        }
        if (d4 == this.dataObject.holeValue || d3 == this.dataObject.holeValue) {
            n8 = 1;
            bl6 = false;
            bl5 = true;
        } else {
            n8 = JCChartUtil.locateXY(d3, d4, d5, d6, d7, d8);
        }
        int n9 = n7;
        int n10 = n8;
        while (bl6 && !this.acceptPoint(n9, n10) && !this.rejectPoint(n9, n10)) {
            double d9;
            double d10;
            int n11 = n4 = n9 != 0 ? n9 : n10;
            if ((n4 & 1) != 0) {
                d10 = d2 + (d4 - d2) * (d5 - d) / (d3 - d);
                d9 = d5;
                n4 = JCChartUtil.locateY(d10, d7, d8);
            } else if ((n4 & 2) != 0) {
                d10 = d2 + (d4 - d2) * (d6 - d) / (d3 - d);
                d9 = d6;
                n4 = JCChartUtil.locateY(d10, d7, d8);
            } else if ((n4 & 4) != 0) {
                d9 = d + (d3 - d) * (d7 - d2) / (d4 - d2);
                d10 = d7;
                n4 = JCChartUtil.locateX(d9, d5, d6);
            } else {
                d9 = d + (d3 - d) * (d8 - d2) / (d4 - d2);
                d10 = d8;
                n4 = JCChartUtil.locateX(d9, d5, d6);
            }
            if (n9 != 0) {
                n9 = n4;
                d = d9;
                d2 = d10;
                bl3 = false;
                continue;
            }
            n10 = n4;
            d3 = d9;
            d4 = d10;
            bl4 = false;
        }
        int n12 = n4 = n2 != n3 || !bl5 || n7 != 0 && n8 != 0 ? 0 : 1;
        if (this.acceptPoint(n9, n10) || n4 != 0) {
            if (bl) {
                if (!bl5) {
                    this.addClippedPoint(vector, null, n2, d3, d4, jCAxis, jCAxis2, bl2, bl4, n6);
                    bl = n8 == 0;
                } else {
                    bl = false;
                    if (vector != null) {
                        vector.addElement(null);
                    }
                }
            } else {
                if (n4 != 0 && n8 == 0) {
                    d = d3;
                    d2 = d4;
                    bl3 = bl4;
                    n5 = n6;
                }
                this.addClippedPoint(vector, null, n2, d, d2, jCAxis, jCAxis2, bl2, bl3, n5);
                if (n4 == 0) {
                    this.addClippedPoint(vector, null, n2 + 1, d3, d4, jCAxis, jCAxis2, bl2, bl4, n6);
                }
                bl = n8 == 0;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    boolean acceptPoint(int n, int n2) {
        return (n | n2) == 0;
    }

    boolean rejectPoint(int n, int n2) {
        return (n & n2) != 0;
    }
}

